unit TablesyncForm_u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  LCDBRecord_u, ExtCtrls, DBCtrls, Grids, DBGrids, Db, DBTables, StdCtrls,
  ComCtrls;

{
USAGE INSTRUCTIONS

Create or drop TLCDBSyncData component on your form.

Assign properties and events.
- UpdateIDFieldName refers to the field that will be used to compare changes.
- 14 characters is needed and the data is yyyymmddhhmmss.
  Use formatdatetime('yyyymmddhhmmss', now) to get correct value.
- BriefcaseChangedFieldName refers to the field that is used to trace briefcase changes.
  The value 0 means unchanged, 1 client has changed, 2 client has deleted the record (will be deleted on next server sync)
- Sync can be done in these three ways:
  1. soClientToServer, all changes from the client will be sent to the server.
  2. soServerToClient, all changes from the server will be sent to the client.
  3. soDeleteRecords, all records that are delete (server and client) will be deleted.
- SearchKey is the normal key that you would use when using Locate e.g. FIELD1;FIELD2;FIELD3 for
  a key containing those three fields.
  
Use execute to perform the sync.

NOTES:


}

type
  TTablesyncForm = class(TForm)
    Table1: TTable;
    Table2: TTable;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    Panel1: TPanel;
    ProgressBar1: TProgressBar;
    Button2: TButton;
    Server2Briefcase: TCheckBox;
    Briefcase2Server: TCheckBox;
    DeleteOldRecords: TCheckBox;
    Panel3: TPanel;
    Panel2: TPanel;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    Splitter1: TSplitter;
    DBNavigator2: TDBNavigator;
    DBGrid2: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    VerLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Table1BeforePost(DataSet: TDataSet);
    procedure Table2BeforePost(DataSet: TDataSet);
    procedure Button2Click(Sender: TObject);
    procedure Table2BeforeDelete(DataSet: TDataSet);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    syncingData: Boolean;
    { Private declarations }
  public
    procedure syncProgress(Sender: TObject; pPosition, pMax: Integer );
    { Public declarations }
  end;

var
  TablesyncForm: TTablesyncForm;

implementation

{$R *.DFM}

procedure TTablesyncForm.FormCreate(Sender: TObject);
begin
  Table1.Open;
  Table2.Open;
  VerLabel.Caption := 'LC Data Sync V ' + LCDBRecord_u.COMPONENT_VERSION;
end;

procedure TTablesyncForm.Table1BeforePost(DataSet: TDataSet);
begin
  if not syncingData then
    Table1.FieldByName('SYNCDTM').AsString := formatdatetime('yyyymmddhhmmss', now);
end;

procedure TTablesyncForm.Table2BeforePost(DataSet: TDataSet);
begin
  if not syncingData then
  begin

    if Table2.FieldByName('CLIENTCHANGED').AsString <> '2' then
      Table2.FieldByName('CLIENTCHANGED').AsString := '1';

  end; 
end;

procedure TTablesyncForm.syncProgress(Sender: TObject; pPosition,
  pMax: Integer);
begin

  ProgressBar1.Position := pPosition;
  ProgressBar1.Max := pMax;

end;

procedure TTablesyncForm.Button2Click(Sender: TObject);
var
  lSync:  TLCDBSyncData;
begin

  //SyncingData is only here due to the fact that we use same dataset for
  //syncing and editing.

  syncingData := True;
  lSync := TLCDBSyncData.Create(Self);
  lSync.OnSyncProgress := syncProgress;
  lSync.MainDataset := Table1;
  lSync.BriefcaseDataSet := Table2;
  lSync.SearchKey := 'TESTID';
  lSync.BriefcaseChangedFieldName := 'CLIENTCHANGED';
  lSync.UpdateIDFieldName := 'SYNCDTM';

  if Briefcase2Server.Checked then
    lSync.SyncOptions := lSync.SyncOptions + [soClientToServer];

  if Server2Briefcase.Checked then
    lSync.SyncOptions := lSync.SyncOptions + [soServerToClient];

  if DeleteOldRecords.Checked then
    lSync.SyncOptions := lSync.SyncOptions + [soDeleteRecords];

  lSync.Execute;
  lSync.Free;
  syncingData := False;
  showmessagE('finished!');
end;

procedure TTablesyncForm.Table2BeforeDelete(DataSet: TDataSet);
begin

  if not syncingData then
  begin

    Table2.Edit;
    Table2.FieldByName('CLIENTCHANGED').AsString := '2';
    Table2.Post;
    Abort;

  end;

end;

procedure TTablesyncForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Table1.Close;
  Table2.Close;
end;

end.
